/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.fabric.networking_api.client;

import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.C2SConfigurationChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientConfigurationPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import org.sinytra.fabric.networking_api.client.NeoClientPacketSender;

public class NeoClientCommonNetworking {
    public static void onRegisterPacket(ICommonPacketListener listener, Set<ResourceLocation> ids) {
        ConnectionProtocol protocol = listener.protocol();
        List<ResourceLocation> listIds = List.copyOf(ids);
        if (protocol == ConnectionProtocol.CONFIGURATION) {
            listener.getPacketProcessor().scheduleIfPossible(() -> ((C2SConfigurationChannelEvents.Register)C2SConfigurationChannelEvents.REGISTER.invoker()).onChannelRegister((ClientConfigurationPacketListenerImpl)listener, new NeoClientPacketSender(listener.getConnection()), Minecraft.getInstance(), listIds));
        } else if (protocol == ConnectionProtocol.PLAY) {
            listener.getPacketProcessor().scheduleIfPossible(() -> ((C2SPlayChannelEvents.Register)C2SPlayChannelEvents.REGISTER.invoker()).onChannelRegister((ClientPacketListener)listener, new NeoClientPacketSender(listener.getConnection()), Minecraft.getInstance(), listIds));
        }
    }

    public static void onUnregisterPacket(ICommonPacketListener listener, Set<ResourceLocation> ids) {
        ConnectionProtocol protocol = listener.protocol();
        List<ResourceLocation> listIds = List.copyOf(ids);
        if (protocol == ConnectionProtocol.CONFIGURATION) {
            listener.getPacketProcessor().scheduleIfPossible(() -> ((C2SConfigurationChannelEvents.Unregister)C2SConfigurationChannelEvents.UNREGISTER.invoker()).onChannelUnregister((ClientConfigurationPacketListenerImpl)listener, new NeoClientPacketSender(listener.getConnection()), Minecraft.getInstance(), listIds));
        } else if (protocol == ConnectionProtocol.PLAY) {
            listener.getPacketProcessor().scheduleIfPossible(() -> ((C2SPlayChannelEvents.Unregister)C2SPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister((ClientPacketListener)listener, new NeoClientPacketSender(listener.getConnection()), Minecraft.getInstance(), listIds));
        }
    }
}

